﻿var publishInMarketSight = {
    context: $(".v-publishInMarketSight"),
    initialize: function () {
        var isStopped = $("#ItemStatus", publishInMarketSight.context).val() == "1"; // Status.Stopped = 1
        $("#CasesExtractionType_All", publishInMarketSight.context).prop("disabled", !isStopped);
    },
    bindEvents: function () {
        publishInMarketSight.context.on("change", "input[name='CasesExtractionType']", function () {
            var isPublishAll = $(this).val() == Enum.MarketSightCasesExtractionType.All;

            $(".v-publishWarning", publishInMarketSight.context).toggle(isPublishAll);
            $(".v-confirmPublish", publishInMarketSight.context).prop("checked", !isPublishAll);

            publishInMarketSight.disableConfirmButton(false, isPublishAll);
        });

        publishInMarketSight.context.on("change", ".v-confirmPublish", function () {
            publishInMarketSight.disableConfirmButton($(this).is(":checked"), $("#CasesExtractionType_All", publishInMarketSight.context).is(":checked"))
        });
    },
    disableConfirmButton: function (isConfirmed, isPublishAll) {
        $(".v-confirmButton", publishInMarketSight.context).prop("disabled", !isConfirmed && isPublishAll);
    }
}

$(document).ready(function () {
    if (publishInMarketSight.context.length > 0) {
        publishInMarketSight.initialize();
        publishInMarketSight.bindEvents();
    }
});